/*
 * Palette.java
 *
 * Created on June 23, 2006, 3:10 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package ags.ui.graphics;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Administrator
 */
public abstract class Palette {
    // The color palette of the apple is not very wide, so we have a little room here
    public int MATCH_TOLERANCE = 64;
    
    /**
     * Creates a new instance of Palette
     */
    public Palette() {
        colors = new ArrayList<int[]>();
        initPalette();
    }

    protected abstract void initPalette();
    
    List<int[]> colors;
    
    public int[] getColor(int col) {
        return colors.get(col);
    }
    
    public int getColorInt(int c) {
        int[] col = getColor(c);
        return 65536*col[0] + 256*col[1] + col[2];
    }
    
    public void addColor(int[] col) {
        colors.add(col);        
    }
    
    public void addColor(int r, int g, int b) {
        int[] col = new int[3];
        col[0] = r;
        col[1] = g;
        col[2] = b;
        addColor(col);
    }

    public int findColor(int color) {
        int[] col = parseIntColor(color);
        return findColor(col);
    }

    private int[] parseIntColor(final int color) {
        int r = (color >> 16) & 0x00ff;
        int g = (color >> 8) & 0x00ff;
        int b = color & 0x00ff;
        int[] col = new int[3];
        col[0] = r;
        col[1] = g;
        col[2] = b;
        return col;
    }
    
    public int findColor(int[] color) {
        int lastDiff = COLOR_DISTANCE_MAX;
        int bestFit = 0;
        for (int i=0; i < colors.size(); i++) {
            int[] test = colors.get(i);
            int diff = (int) distance(color, test);
            if (diff < lastDiff) {
                lastDiff = diff;
                bestFit = i;
            }
        }
        return bestFit;
    }

    public static int COLOR_DISTANCE_MAX = 49744125;
    // max value = 49744125
    public double distance(int[] color, int[] test) {
        return Math.pow((double) Math.abs(color[0] - test[0]), 3.0) +
               Math.pow(Math.abs(color[1] - test[1]), 3.0) +
               Math.pow(Math.abs(color[2] - test[2]), 3.0);        
    }
}